/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util.impl;

import com.ibm.hwmca.fw.servlet.util.impl.LogOutputWindow;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;

public class GuiLogHandler
extends Handler {
    boolean doneHeader;
    boolean showSource;
    boolean showTime;
    boolean showSequence;
    boolean showThread;
    LogOutputWindow logOutputWindow;
    Preferences userPrefs = Preferences.userNodeForPackage(class$com$ibm$hwmca$fw$servlet$util$impl$GuiLogHandler == null ? (class$com$ibm$hwmca$fw$servlet$util$impl$GuiLogHandler = GuiLogHandler.class$("com.ibm.hwmca.fw.servlet.util.impl.GuiLogHandler")) : class$com$ibm$hwmca$fw$servlet$util$impl$GuiLogHandler);
    private static ThreadLocal formatBuffer = new ThreadLocal(){

        protected Object initialValue() {
            return new StringBuffer(200);
        }
    };
    static /* synthetic */ Class class$com$ibm$hwmca$fw$servlet$util$impl$GuiLogHandler;

    public GuiLogHandler() {
        this.showSource = this.userPrefs.getBoolean("guiloghandler.showSource", false);
        this.showTime = this.userPrefs.getBoolean("guiloghandler.showTime", true);
        this.showSequence = this.userPrefs.getBoolean("guiloghandler.showSequence", false);
        this.showThread = this.userPrefs.getBoolean("guiloghandler.showThread", false);
        this.setFormatter(new GuiFormatter());
        this.logOutputWindow = new LogOutputWindow(this, this.userPrefs);
    }

    void setShowSource(boolean show) {
        this.showSource = show;
        this.userPrefs.putBoolean("guiloghandler.showSource", show);
        try {
            this.userPrefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    boolean getShowSource() {
        return this.showSource;
    }

    void setShowTime(boolean show) {
        this.showTime = show;
        this.userPrefs.putBoolean("guiloghandler.showTime", show);
        try {
            this.userPrefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    boolean getShowTime() {
        return this.showTime;
    }

    void setShowSequence(boolean show) {
        this.showSequence = show;
        this.userPrefs.putBoolean("guiloghandler.showSequence", show);
        try {
            this.userPrefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    boolean getShowSequence() {
        return this.showSequence;
    }

    void setShowThread(boolean show) {
        this.showThread = show;
        this.userPrefs.putBoolean("guiloghandler.showThread", show);
        try {
            this.userPrefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    boolean getShowThread() {
        return this.showThread;
    }

    public void publish(LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception e) {
            this.reportError(null, e, 5);
            return;
        }
        try {
            if (!this.doneHeader) {
                String header = this.getFormatter().getHead(this);
                if (header.length() > 0) {
                    this.logOutputWindow.addText(header, Level.SEVERE);
                }
                this.doneHeader = true;
            }
            this.logOutputWindow.addText(msg, record.getLevel());
            Throwable e = record.getThrown();
            if (e != null) {
                StringWriter buffer = new StringWriter();
                PrintWriter stack = new PrintWriter(buffer);
                e.printStackTrace(stack);
                while (e != null) {
                    if (e instanceof ServletException) {
                        e = ((ServletException)e).getRootCause();
                    } else {
                        if (!(e instanceof JspException)) break;
                        e = ((JspException)e).getRootCause();
                    }
                    if (e == null) continue;
                    stack.println();
                    stack.println("Caused by:");
                    e.printStackTrace(stack);
                }
                stack.flush();
                this.logOutputWindow.addText(buffer.toString(), record.getLevel());
            }
        }
        catch (Exception e) {
            this.reportError(null, e, 1);
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        this.logOutputWindow.reset();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class GuiFormatter
    extends Formatter {
        DateFormat dateFormat;
        FieldPosition fillerPosition;

        private GuiFormatter() {
        }

        public String format(LogRecord record) {
            StringBuffer sb = (StringBuffer)formatBuffer.get();
            sb.setLength(0);
            if (GuiLogHandler.this.showSequence) {
                sb.append(record.getSequenceNumber());
                sb.append(", ");
            }
            if (GuiLogHandler.this.showTime) {
                if (this.dateFormat == null) {
                    try {
                        ClientUserContext userContext = ClientUserContext.getUserContext();
                        this.dateFormat = new SimpleDateFormat("HH:mm:ss.SSS", userContext.getLocale());
                        this.dateFormat.setTimeZone(userContext.getTimeZone());
                    }
                    catch (NullContextException e) {
                        this.dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                    }
                    this.fillerPosition = new FieldPosition(0);
                }
                this.dateFormat.format(new Date(record.getMillis()), sb, this.fillerPosition);
                sb.append(", ");
            }
            if (GuiLogHandler.this.showThread) {
                sb.append("Thread==");
                sb.append(record.getThreadID());
                sb.append(", ");
            }
            if (GuiLogHandler.this.showSource && record.getSourceClassName() != null) {
                String className = record.getSourceClassName();
                int lastDot = className.lastIndexOf(46);
                if (lastDot == -1) {
                    sb.append(className);
                } else {
                    sb.append(className.substring(lastDot + 1));
                }
                if (record.getSourceMethodName() != null) {
                    sb.append('.');
                    sb.append(record.getSourceMethodName());
                    sb.append("()");
                }
                sb.append(", ");
            }
            sb.append(this.formatMessage(record));
            if (sb.charAt(sb.length() - 1) != '\n') {
                sb.append('\n');
            }
            return sb.toString();
        }
    }
}

